function [Delta_y_plot_top,Delta_y_UR_plot,e_plot,M_a_plot,p_inc,p_plot,p_2_plot,...
    p_3_plot,p_seismic,p_tilde_2_plot,p_tilde_3_plot,p_tilde_unc_2_plot,p_tilde_unc_3_plot,...
    y_1_plot,y_2_plot,y_3_plot,y_4_plot,...
    y_tilde_1_plot,y_tilde_2_plot,y_tilde_3_plot,y_tilde_4_plot,...
    y_tilde_unc_2_plot,y_tilde_unc_3_plot] = ...
    fault_slip_patch_bounds(a,alpha,b,cheb_terms,colors,delta_c,...
    D_center,Delta_p_init,Delta_p_max,Delta_p_min,Delta_y_int,Delta_y_target,eps_reg,...
    eta_reg,f_damp,flag_cheb,flag_check,flag_cont,flag_cor,flag_decouple,flag_echo,...
    flag_eig_use,flag_fric,flag_lag,flag_M,flag_paper,flag_plot_cap,flag_plot_diag,...
    flag_plot_eig,flag_plot_fields,flag_plot_snap,flag_reg,flag_top_only,g,G,kappa,K_eff,...
    max_iter_coupled,mu_dyn,mu_st,n_max_int,n_min_int,nu,p_0_center,...
    p_inc_01,p_inc_02,p_inc_03,p_inc_04,p_inc_05,...
    p_max_bounds,p_min_bounds,phi,rho_f,rho_s,sigma_v_0,small_patch,theta,tol_deriv,...
    tol_rel_coupled,...
    y_plot_max_bounds,y_plot_max_delta_1,y_plot_max_delta_2,y_plot_max_sigma,...
    y_plot_min_bounds,y_plot_min_delta_1,y_plot_min_delta_2,y_plot_min_sigma,...
    y_plot_n_pt)
%
% Computes and plots the intersections y_i, i = 1,...,4, of the combined shear stress with the
% right slip boundary (i.e. the zeros of the pre-slip Coulomb stresses), and the boundaries of
% the slip patches y_tilde_i, i = 1,...,4, (i.e. the zeros of the post-slip Coulomb stresses)
% as a function of depletion pressure p_inc. Uses a variable pressure step size.
%

% Retrieve colors:
blue = colors(1,:);
green = colors(3,:);
   
% Initialize snap-shot plot variables:
if flag_plot_snap == 1 && flag_cheb == 0
    d2delta_ds_dp_01 = 0; d2delta_ds_dp_02 = 0; d2delta_ds_dp_03 = 0; d2delta_ds_dp_04 = 0;
        d2delta_ds_dp_05 = 0;
    ddelta_dp_01 = 0; ddelta_dp_02 = 0; ddelta_dp_03 = 0; ddelta_dp_04 = 0; ddelta_dp_05 = 0;
    ddelta_ds = 0;
    ddelta_ds_01 = 0; ddelta_ds_02 = 0; ddelta_ds_03 = 0; ddelta_ds_04 = 0; ddelta_ds_05 = 0;
    ddelta_ds_pert = 0;
    delta = 0;
    delta_01 = 0; delta_02 = 0; delta_03 = 0; delta_04 = 0; delta_05 = 0;
    delta_pert = 0;
    dy = 0;
    p_inc_pert = 0;
    plot_01 = 0; plot_02 = 0; plot_03 = 0; plot_04 = 0; plot_05 = 0; 
    sigma_C_01 = 0; sigma_C_02 = 0; sigma_C_03 = 0; sigma_C_04 = 0; sigma_C_05 = 0; 
    sigma_C_post_01 = 0; sigma_C_post_02 = 0; sigma_C_post_03 = 0; sigma_C_post_04 = 0; ...
        sigma_C_post_05 = 0; 
    xi = 0;
    y_delta = 0;
    y_delta_01 = 0; y_delta_02 = 0; y_delta_03 = 0; y_delta_04 = 0; y_delta_05 = 0;
    y_delta_pert = 0;
    y_sigma_01 = 0; y_sigma_02 = 0; y_sigma_03 = 0; y_sigma_04 = 0; y_sigma_05 = 0; 
    y_tilde = zeros(1,4);
    y_tilde_01 = zeros(1,4); y_tilde_02 = zeros(1,4); y_tilde_03 = zeros(1,4); 
        y_tilde_04 = zeros(1,4); y_tilde_05 = zeros(1,4);
    sigma_breve_01 = 0; sigma_breve_02 = 0; sigma_breve_03 = 0; sigma_breve_04 = 0;
        sigma_breve_05 = 0; 
    y_breve_01 = 0; y_breve_02 = 0; y_breve_03 = 0; y_breve_04 = 0; y_breve_05 = 0; 
    sigma_shear_comb_01 = 0; sigma_shear_comb_02 = 0; sigma_shear_comb_03 = 0;
        sigma_shear_comb_04 = 0; sigma_shear_comb_05 = 0; 
    sigma_slip_01 = 0; sigma_slip_02 = 0; sigma_slip_03 = 0; sigma_slip_04 = 0;
        sigma_slip_05 = 0;  
    y_inter_01 = zeros(1,4); y_inter_02 = zeros(1,4); y_inter_03 = zeros(1,4);
        y_inter_04 = zeros(1,4); y_inter_05 = zeros(1,4);  
end

% Initialize other variables:
n_plot_max = 5000; % max. nr. of pressure steps; for memory allocation
n_plot_fields_p = 100; % nr. of points in p direction for field plots
n_plot_fields_t = n_plot_fields_p; % nr. of points in t direction for field plots
n_plot_fields_y = 100; % nr. of points in y direction for field plots
T_y = 70; % total depletion time, years

if flag_plot_fields == 1 && flag_cheb == 1 
    ddelta_ds_fields = zeros(n_plot_fields_y,n_plot_max);
    delta_fields = zeros(n_plot_fields_y,n_plot_max);
    y_fields = linspace(y_plot_min_delta_2,y_plot_max_delta_2,n_plot_fields_y);
end
dp_dDelta_y_num_bot = zeros(n_plot_max,1);
dp_dDelta_y_num_top = zeros(n_plot_max,1);
Delta_p = zeros(n_plot_max,1);
Delta_y_max_obs = zeros(n_plot_max,1);
Delta_y_UR_bot = zeros(n_plot_max,1);
Delta_y_UR_top = zeros(n_plot_max,1);
Delta_y_eig_bot = zeros(n_plot_max,1);
Delta_y_eig_top = zeros(n_plot_max,1);
epsilon = zeros(n_plot_max,1);
flag_eig_bot = 0;
flag_eig_top = 0;
flag_reset_p_inc = 0;
M_a = zeros(n_plot_max,1);
p_eig = 0;
p_inc_save = 0;
rms_dR_dp = zeros(n_plot_max,1);
rms_dW_dp_delta = zeros(n_plot_max,1);
rms_W_ddelta_dp = zeros(n_plot_max,1);
rms_W_ddelta_dp_2 = zeros(n_plot_max,1);
flag_loc_seismic = 0;
p = zeros(n_plot_max,1);
y_1 = zeros(n_plot_max,1);
y_2 = zeros(n_plot_max,1);
y_3 = zeros(n_plot_max,1);
y_4 = zeros(n_plot_max,1);
y_tilde_unc_1 = zeros(n_plot_max,1);
y_tilde_unc_2 = zeros(n_plot_max,1);
y_tilde_unc_3 = zeros(n_plot_max,1);
y_tilde_unc_4 = zeros(n_plot_max,1);
y_tilde_1 = zeros(n_plot_max,1);
y_tilde_2 = zeros(n_plot_max,1);
y_tilde_3 = zeros(n_plot_max,1);
y_tilde_4 = zeros(n_plot_max,1);
i_max_2_num = 0;
i_max_3_num = 0;
i_max_2_tilde_unc = 0;
i_max_3_tilde_unc = 0;
i_max_2_tilde = 0;
i_max_3_tilde = 0;
i = 0;
p_inc = p_max_bounds;
flag_seismic = 0;
keep_step = 0;
if flag_echo > 0
        if flag_fric == 1
            fprintf('\rSimulating fault slip with constant friction.\r');
        end
        if flag_fric == 2
            fprintf('\rSimulating fault slip with slip-weakening friction.\r');
        end
end
flag_first_call = 1;
while p_inc > p_min_bounds && flag_seismic == 0
    i = i+1;
    % Determine pressure step:
    if i == 1 || i == 2 || keep_step == 1
        Delta_p(i) = Delta_p_init;
    else
        if flag_reset_p_inc == 1 % snap shot plot was generated during previous pressure step
            i = i-1;
            p_inc = p_inc_save;
            flag_reset_p_inc = 0;
        else
            Delta_p_old = Delta_p(i-1);
            y_vec = [y_1(i-1); y_2(i-1); y_3(i-1); y_4(i-1)];
            y_prev_vec = [y_1(i-2); y_2(i-2); y_3(i-2); y_4(i-2)];
            y_tilde_unc_vec = [y_tilde_unc_1(i-1); y_tilde_unc_2(i-1); y_tilde_unc_3(i-1); ...
                y_tilde_unc_4(i-1)];
            y_tilde_unc_prev_vec = [y_tilde_unc_1(i-2); y_tilde_unc_2(i-2); ...
                y_tilde_unc_3(i-2); y_tilde_unc_4(i-2)];
            y_tilde_vec = [y_tilde_1(i-1); y_tilde_2(i-1); y_tilde_3(i-1); y_tilde_4(i-1)];
            y_tilde_prev_vec = [y_tilde_1(i-2); y_tilde_2(i-2); y_tilde_3(i-2); ...
                y_tilde_4(i-2)];
            [Delta_p(i),Delta_y_max_obs(i)] = fault_slip_pressure_step(Delta_p_init,...
                Delta_p_max,Delta_p_min,Delta_p_old,Delta_y_target,y_prev_vec,...
                y_tilde_unc_vec,y_tilde_unc_prev_vec,y_tilde_vec,y_tilde_prev_vec,y_vec);
        end
    end
    if i > 1
        p_inc_save = p_inc; 
        p_inc = p_inc + Delta_p(i); % note that p_inc and Delta_p are negative
    end
    
    % Check if pressure step triggers a snap shot plot, and if so, reset pressure to ...
        % required value. Note that p < 0):
    if flag_plot_snap == 1 && flag_cheb == 0
        if p_inc <= p_inc_01 && plot_01 == 0 % note that p_inc < 0
            p_inc = p_inc_01;
            flag_reset_p_inc = 1;
        end
        if p_inc <= p_inc_02 && plot_02 == 0
            p_inc = p_inc_02;
            flag_reset_p_inc = 1;
        end
        if p_inc <= p_inc_03 && plot_03 == 0
            p_inc = p_inc_03;
            flag_reset_p_inc = 1;
        end
        if p_inc <= p_inc_04 && plot_04 == 0
            p_inc = p_inc_04;
            flag_reset_p_inc = 1;
        end
        if p_inc <= p_inc_05 && plot_05 == 0
            p_inc = p_inc_05;
            flag_reset_p_inc = 1;
        end
    end
    if p_inc < p_min_bounds % note that p_inc < 0
        p_inc = p_min_bounds; % final pressure step has been reached
    end
    p(i) = p_inc; % stores incremental pressures for plotting
    if flag_echo == 2
        fprintf('\rPressure step %3.0i                       p_inc = %7.4f MPa\r',i,p_inc/1e6);
    end
    
    % Compute Coulomb stress intersections:
    if flag_fric == 1 || i == 1 || keep_step == 1
        flag_fric_loc = 1; % local value
        delta = 0;
        y_delta = 0;
    else
        flag_fric_loc = flag_fric;
    end
    [y_1(i),y_2(i),y_3(i),y_4(i)] = ...
        fault_slip_intersect_num(a,alpha,b,delta,delta_c,D_center,eps_reg,eta_reg,...
        flag_fric_loc,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,p_inc,phi,rho_f,...
        rho_s,sigma_v_0,theta,y_delta);
    if y_3(i) > y_2(i)
        i_max_2_num = i; % maximum number of points in graph of y_2
        i_max_3_num = i; % maximum number of points in graph of y_3
    end 
    if abs(y_1(i)-y_2(i)) < small_patch || abs(y_3(i)-y_4(i)) < small_patch % patch ...
        keep_step = 1; % keeps pressure increment the same for the next step
        Delta_y_UR_bot(i) = 0; 
        Delta_y_UR_top(i) = 0; 
        Delta_y_eig_bot(i) = 0; 
        Delta_y_eig_top(i) = 0; 
        flag_merged = 0;
        flag_merged_unc = 0;
        y_tilde_unc_2(i) = y_2(i);
        y_tilde_unc_3(i) = y_3(i);
        y_tilde_1(i) = y_1(i);
        y_tilde_2(i) = y_2(i);
        y_tilde_3(i) = y_3(i);
        y_tilde_4(i) = y_4(i);       
    else % larger than very small patch lengths       
        % Compute fault slip:
        if i == 1 || keep_step == 1
            y_tilde_0 = [y_1(i) y_2(i) y_3(i) y_4(i)]; % first guess for slip patch bounds
            keep_step = 0; % recompute pressure increment at next step
            flag_merged = 0;
            flag_merged_unc = 0;
        else
            y_tilde_0 = [y_tilde_1(i-1) y_tilde_2(i-1) y_tilde_3(i-1) y_tilde_4(i-1)]; % takes
            % result from previous pressure step as first guess
        end
        if keep_step == 0
            switch flag_cheb
                case 0 % numerical integration with near-uniform staggered grids for y and xi
                    [ddelta_ds,delta,dy,Delta_y_UR_bot(i),Delta_y_UR_top(i),e_bot,e_top,~,~,...
                        flag_first_call,flag_loc_seismic,flag_merged,flag_merged_unc,...
                        flag_seismic,xi,y_delta,y_tilde,y_tilde_unc] = ...
                        fault_slip_delta(a,alpha,b,cheb_terms,colors,delta,delta_c,D_center,...
                        Delta_y_int,eps_reg,eta_reg,flag_cheb,flag_cor,flag_decouple,...
                        flag_echo,flag_eig_use,flag_first_call,flag_fric_loc,flag_lag,...
                        flag_merged,flag_merged_unc,flag_plot_cap,flag_plot_diag,...
                        flag_plot_eig,flag_plot_snap,flag_reg,flag_reset_p_inc,g,G,i,kappa,...
                        K_eff,max_iter_coupled,mu_dyn,mu_st,n_max_int,n_min_int,nu,...
                        p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,tol_rel_coupled,...
                        y_delta,y_plot_max_delta_1,y_plot_min_delta_1,y_plot_max_delta_2,...
                        y_plot_min_delta_2,y_tilde_0);
                    if flag_reset_p_inc == 1 && flag_fric == 2 % snap shot computation has ...
                        % been triggered; repeat integration for perturbed pressure to ...
                        % compute numerical derivatives for snapshot plots
                        p_pert = -1e3; % pressure pertubation (Pa) 
                        p_inc_pert = p_inc + p_pert; % perturbed incremental pressure
                        [ddelta_ds_pert,delta_pert,~,~,~,~,~,~,~,~,~,~,~,~,~,...
                            y_delta_pert,~,~] = ...
                            fault_slip_delta(a,alpha,b,cheb_terms,colors,delta,delta_c,...
                            D_center,Delta_y_int,eps_reg,eta_reg,flag_cheb,flag_cor,...
                            flag_decouple,flag_echo,flag_eig_use,flag_first_call,...
                            flag_fric_loc,flag_lag,flag_merged,flag_merged_unc,...
                            flag_plot_cap,flag_plot_diag,flag_plot_eig,flag_plot_snap,...
                            flag_reg,flag_reset_p_inc,g,G,i,kappa,K_eff,max_iter_coupled,...
                            mu_dyn,mu_st,n_max_int,n_min_int,nu,p_0_center,p_inc_pert,phi,...
                            rho_f,rho_s,sigma_v_0,theta,tol_rel_coupled,y_delta,...
                            y_plot_max_delta_1,y_plot_min_delta_1,y_plot_max_delta_2,...
                            y_plot_min_delta_2,y_tilde_0);
                    end
                case 1 % semi-analytical inversion through integration with Chebyshev polynom.
                    [ddelta_ds,delta,dp_dDelta_y_num_bot(i),dp_dDelta_y_num_top(i),dy,...
                        Delta_y_UR_bot(i),Delta_y_UR_top(i),e_bot,e_top,~,~,...
                        flag_eig_bot,flag_eig_top,flag_first_call,flag_loc_seismic,...
                        flag_merged,flag_merged_unc,flag_seismic,M_a(i),p_eig,p_inc,xi,...
                        y_delta,y_tilde,y_tilde_unc,work] = ...
                        fault_slip_delta_cheb(a,alpha,b,cheb_terms,colors,delta,delta_c,...
                        D_center,eps_reg,eta_reg,f_damp,flag_cheb,flag_cont,flag_decouple,...
                        flag_echo,flag_eig_bot,flag_eig_top,flag_eig_use,flag_first_call,...
                        flag_fric_loc,flag_lag,flag_merged,flag_merged_unc,flag_M,...
                        flag_plot_cap,flag_plot_diag,flag_plot_eig,flag_reg,flag_top_only,...
                        g,G,i,kappa,K_eff,max_iter_coupled,mu_dyn,mu_st,nu,p_0_center,p_eig,...
                        p_inc,phi,rho_f,rho_s,sigma_v_0,theta,tol_deriv,tol_rel_coupled,...
                        y_delta,y_plot_max_delta_1,y_plot_min_delta_1,y_plot_max_delta_2,...
                        y_plot_min_delta_2,y_tilde_0);
                case 2 % numerical inversion (matrix inversion) with Chebyshev polynomials
                    error('Option flag_cheb = 2 is not operational.');
            end
            Delta_y_eig_bot(i) = 1/e_bot; % inverse of largest eigen value
            Delta_y_eig_top(i) = 1/e_top;
            if flag_fric == 2 && flag_cheb == 1 && flag_plot_diag == 1
                % dR/dp:
                rms_dR_dp(i) = work.rms_dR_dp;
                % dW/dp * delta:                
                rms_dW_dp_delta(i) = work.rms_dW_dp_delta;
                % epsilon:
                epsilon(i) = work.epsilon;
                % W * ddelta/dp:           
                rms_W_ddelta_dp(i) = work.rms_W_ddelta_dp;
                rms_W_ddelta_dp_2(i) = work.rms_W_ddelta_dp_2;
            end
            if flag_seismic == 0
                y_tilde_unc_2(i) = y_tilde_unc(2);
                y_tilde_unc_3(i) = y_tilde_unc(3);
                y_tilde_1(i) = y_tilde(1);
                y_tilde_2(i) = y_tilde(2);
                y_tilde_3(i) = y_tilde(3);
                y_tilde_4(i) = y_tilde(4);
                if flag_merged_unc == 0 % slip patches haven't merged yet (uncoupled computat.)
                    i_max_2_tilde_unc = i; % maximum number of points in graph of y_tilde_unc_2
                    i_max_3_tilde_unc = i; % maximum number of points in graph of y_tilde_unc_3
                end
                if flag_merged == 0 % slip patches haven't merged yet (coupled computation)
                    i_max_2_tilde = i; % maximum number of points in graph of y_tilde_2
                    i_max_3_tilde = i; % maximum number of points in graph of y_tilde_3
                end
            end
        end
    end
    
    % Compute and save data for snap shot plots (only relevant for numerical integration):
    if flag_plot_snap == 1 && flag_cheb == 0 && flag_reset_p_inc == 1
        [d2delta_ds_dp_01,d2delta_ds_dp_02,d2delta_ds_dp_03,d2delta_ds_dp_04,...
                d2delta_ds_dp_05,...
            ddelta_dp_01,ddelta_dp_02,ddelta_dp_03,ddelta_dp_04,ddelta_dp_05,...
            ddelta_ds_01,ddelta_ds_02,ddelta_ds_03,ddelta_ds_04,ddelta_ds_05,...
            delta_01,delta_02,delta_03,delta_04,delta_05,...
            plot_01,plot_02,plot_03,plot_04,plot_05,...
            sigma_breve_01,sigma_breve_02,sigma_breve_03,sigma_breve_04,sigma_breve_05,...
            sigma_C_01,sigma_C_02,sigma_C_03,sigma_C_04,sigma_C_05,...
            sigma_C_post_01,sigma_C_post_02,sigma_C_post_03,sigma_C_post_04,sigma_C_post_05,...
            sigma_shear_comb_01,sigma_shear_comb_02,sigma_shear_comb_03,...
                sigma_shear_comb_04,sigma_shear_comb_05,...
            sigma_slip_01,sigma_slip_02,sigma_slip_03,sigma_slip_04,sigma_slip_05,...
            y_breve_01,y_breve_02,y_breve_03,y_breve_04,y_breve_05,...
            y_delta_01,y_delta_02,y_delta_03,y_delta_04,y_delta_05,...
            y_inter_01,y_inter_02,y_inter_03,y_inter_04,y_inter_05,...
            y_sigma_01,y_sigma_02,y_sigma_03,y_sigma_04,y_sigma_05,...
            y_tilde_01,y_tilde_02,y_tilde_03,y_tilde_04,y_tilde_05] = ...
            fault_slip_compute_snapshots...
            (a,alpha,b,D_center,...
            d2delta_ds_dp_01,d2delta_ds_dp_02,d2delta_ds_dp_03,d2delta_ds_dp_04,...
                d2delta_ds_dp_05,...
            ddelta_dp_01,ddelta_dp_02,ddelta_dp_03,ddelta_dp_04,ddelta_dp_05,...
            ddelta_ds_01,ddelta_ds_02,ddelta_ds_03,ddelta_ds_04,ddelta_ds_05,...
            ddelta_ds,ddelta_ds_pert,...
            delta,...
            delta_01,delta_02,delta_03,delta_04,delta_05,...
            delta_c,delta_pert,...
            dy,Delta_y_int,eps_reg,eta_reg,flag_cheb,flag_fric,flag_merged,...
            flag_reg,G,g,i,K_eff,kappa,keep_step,mu_dyn,mu_st,...
            y_plot_n_pt,nu,p_0_center,p_inc,...
            p_inc_01,p_inc_02,p_inc_03,p_inc_04,p_inc_05,...
            p_inc_pert,phi,...
            plot_01,plot_02,plot_03,plot_04,plot_05,...
            rho_f,rho_s,...
            sigma_breve_01,sigma_breve_02,sigma_breve_03,sigma_breve_04,sigma_breve_05,...
            sigma_C_01,sigma_C_02,sigma_C_03,sigma_C_04,sigma_C_05,...
            sigma_C_post_01,sigma_C_post_02,sigma_C_post_03,sigma_C_post_04,sigma_C_post_05,...
            sigma_shear_comb_01,sigma_shear_comb_02,sigma_shear_comb_03,...
                sigma_shear_comb_04,sigma_shear_comb_05,...
            sigma_slip_01,sigma_slip_02,sigma_slip_03,sigma_slip_04,sigma_slip_05,...
            sigma_v_0,theta,xi,y_delta,y_tilde,...
            y_plot_max_delta_2,y_plot_min_delta_2,y_plot_max_sigma,y_plot_min_sigma,...
            y_1,y_2,y_3,y_4,...
            y_breve_01,y_breve_02,y_breve_03,y_breve_04,y_breve_05,...
            y_delta_01,y_delta_02,y_delta_03,y_delta_04,y_delta_05,...
            y_delta_pert,...
            y_inter_01,y_inter_02,y_inter_03,y_inter_04,y_inter_05,...
            y_sigma_01,y_sigma_02,y_sigma_03,y_sigma_04,y_sigma_05,...
            y_tilde_01,y_tilde_02,y_tilde_03,y_tilde_04,y_tilde_05);
    end
    if p_inc == p_min_bounds && flag_echo > 0
        fprintf('\rFinal depletion pressure has been reached.\r\r');
    end
    
    % Create field plots (only relevant for Chebyshev integration):
    if flag_plot_fields == 1 && flag_cheb == 1 && keep_step == 0
        delta_int = interp1(y_delta,delta,y_fields); % m
        y_fields = linspace(y_plot_min_delta_2,y_plot_max_delta_2,n_plot_fields_y); % m
        ddelta_ds_int = interp1(y_delta,ddelta_ds,y_fields); % m/m
        delta_fields(1:n_plot_fields_y,i) = delta_int; % m      
        ddelta_ds_fields(1:n_plot_fields_y,i) = ddelta_ds_int; % m/m
    end   
end

% Create snapshot plots (only relevant for numerical integration):
if flag_plot_snap == 1 && flag_cheb == 0
    fault_slip_plot_snapshots(...
        a,b,colors,...
        d2delta_ds_dp_01,d2delta_ds_dp_02,d2delta_ds_dp_03,d2delta_ds_dp_04,...
            d2delta_ds_dp_05,...
        ddelta_dp_01,ddelta_dp_02,ddelta_dp_03,ddelta_dp_04,ddelta_dp_05,...
        ddelta_ds_01,ddelta_ds_02,ddelta_ds_03,ddelta_ds_04,ddelta_ds_05,...
        delta_01,delta_02,delta_03,delta_04,delta_05,...
        flag_fric,flag_paper,flag_plot_cap,...
        sigma_breve_01,sigma_breve_02,sigma_breve_03,sigma_breve_04,sigma_breve_05,...
        sigma_C_01,sigma_C_02,sigma_C_03,sigma_C_04,sigma_C_05,...
        sigma_C_post_01,sigma_C_post_02,sigma_C_post_03,sigma_C_post_04,sigma_C_post_05,...
        sigma_shear_comb_01,sigma_shear_comb_02,sigma_shear_comb_03,sigma_shear_comb_04,...
            sigma_shear_comb_05,...
        sigma_slip_01,sigma_slip_02,sigma_slip_03,sigma_slip_04,sigma_slip_05,...
        theta,...
        y_breve_01,y_breve_02,y_breve_03,y_breve_04,y_breve_05,...
        y_delta_01,y_delta_02,y_delta_03,y_delta_04,y_delta_05,...
        y_inter_01,y_inter_02,y_inter_03,y_inter_04,y_inter_05,...
        y_plot_max_delta_1,y_plot_min_delta_1,...
        y_plot_max_delta_2,y_plot_min_delta_2,...
        y_plot_max_sigma,y_plot_min_sigma,...
        y_sigma_01,y_sigma_02,y_sigma_03,y_sigma_04,y_sigma_05,...
        y_tilde_01,y_tilde_02,y_tilde_03,y_tilde_04,y_tilde_05);
end

% Determine relevant eigenvalues depending on location of seismicity:
if flag_loc_seismic == 0 % no seismicity
    Delta_y_UR = zeros(i,1);
    e_help = zeros(i,1);
end
if flag_loc_seismic == 1 % seismicity in bottom patch
    Delta_y_UR = Delta_y_UR_bot;
    e_help = 1./Delta_y_eig_bot;
end
if flag_loc_seismic == 2 % seismicity in top patch
    Delta_y_UR = Delta_y_UR_top;
    e_help = 1./Delta_y_eig_top;
end
if flag_loc_seismic == 3 % seismicity in merged patches - not yet functional
    Delta_y_UR = zeros(i,1);
    e_help = zeros(i,1);
end

% Create main plot (slip patch boundaries y_i and y_tilde_i as a function of depletion pr.):
[Delta_p_plot,Delta_y_max_obs_plot,Delta_y_plot_bot,Delta_y_plot_top,Delta_y_UR_plot,e_plot,...
    M_a_plot,p_plot,p_2_plot,p_3_plot,p_seismic,p_tilde_2_plot,p_tilde_3_plot,...
    p_tilde_unc_2_plot,p_tilde_unc_3_plot,...
    y_1_plot,y_2_plot,y_3_plot,y_4_plot,...
    y_tilde_1_plot,y_tilde_2_plot,y_tilde_3_plot,y_tilde_4_plot,...
    y_tilde_unc_2_plot,y_tilde_unc_3_plot] = ...
    fault_slip_plot_patch_boundaries...
    (a,colors,Delta_p,Delta_y_max_obs,Delta_y_UR,e_help,flag_check,flag_fric,flag_paper,...
    flag_plot_cap,i,...
    i_max_2_num,i_max_2_tilde,i_max_2_tilde_unc,...
    i_max_3_num,i_max_3_tilde,i_max_3_tilde_unc,...
    M_a,n_plot_max,p,y_1,y_2,y_3,y_4,...
    p_max_bounds,p_min_bounds,...
    y_plot_max_bounds,y_plot_min_bounds,...
    y_tilde_1,y_tilde_2,y_tilde_3,y_tilde_4,y_tilde_unc_2,y_tilde_unc_3);

% Plot loading stress components:
if  flag_plot_diag == 1 && flag_fric == 2
    figure
    subplot(1,3,1)
    i_seismic = i_max_2_tilde;
    hold on
    plot(-p(1:i_seismic)/1e6,rms_dR_dp(1:i_seismic),'LineStyle','-','Color','r','LineWidth',1.5)
    plot(-p(1:i_seismic)/1e6,rms_dW_dp_delta(1:i_seismic),'LineStyle','-','Color',blue,'LineWidth',1.5)
    plot(-p(1:i_seismic)/1e6,rms_W_ddelta_dp(1:i_seismic),'LineStyle','-','Color','k','LineWidth',1.5)
    plot(-p(1:i_seismic)/1e6,epsilon(1:i_seismic),'LineStyle','-','Color',green,'LineWidth',1.5)
%     plot(-p(1:i_seismic)/1e6,rms_W_ddelta_dp_2(1:i_seismic),'LineStyle','-','Color',green,'LineWidth',1.5)
%     plot(-p(1:i_seismic)/1e6,rms_W_ddelta_dp_2(1:i_seismic)./rms_W_ddelta_dp(1:i_seismic),'LineStyle','-','Color',orange,'LineWidth',1.5)
    y_plot_max_local = max([max(rms_dR_dp),max(rms_dW_dp_delta),max(rms_W_ddelta_dp)]);
    y_plot_min_local = min([min(rms_dR_dp),min(rms_dW_dp_delta),min(rms_W_ddelta_dp)]);
    line([-p_seismic/1e6 -p_seismic/1e6],[y_plot_min_local y_plot_max_local],...
        'LineStyle',':','Color','r','LineWidth',1.0)
    hold off
%     axis([-p_max_bounds/1e6 -p_min_bounds/1e6 -inf inf])
    axis([14 18 0 5])
%    axis([14 18 0 2.0])
    box on
    grid on
    xlabel('$\it -p$ (MPa)','Interpreter','latex','FontSize',11)
%     ylabel('$\rm rms ({\it \dot R}), \rm rms ({\it \dot W \delta}), \rm rms ({\it W \dot\delta})$ (-)',...
%         'Interpreter','latex','FontSize',11)
    ylabel('$\rm rms ({\it \dot R}), \rm rms ({\it \dot W \delta}), \rm rms ({\it W \dot\delta}), \it\epsilon$ (-)',...
        'Interpreter','latex','FontSize',11)
%     legend('$\it \dot R$','$\it \dot W \delta$','$\it W \dot\delta$','Interpreter',...
%         'latex','FontSize',11,'location','northwest')
    legend('$\it \dot R$','$\it \dot W \delta$','$\it W \dot\delta$','$\it\epsilon$','Interpreter',...
        'latex','FontSize',11,'location','northwest')
    if flag_plot_cap == 1
        [t,s] = title('patch\_bounds',' '); % first line: plot file locator
        t.Color = 'r';
        t.FontSize = 10;
        s.FontSize = 10;
        t.FontWeight = 'normal';
        s.FontWeight = 'normal';
    end

%     subplot(1,2,2)
%     hold on
%     plot(dR_dp,y_top,'LineStyle','-','Color','r','LineWidth',1.5)
% %     plot(dR_dp_num,y_top,'LineStyle','--','Color',green,'LineWidth',1.5)    
%     plot(dW_dp_delta,y_top,'LineStyle','-','Color',blue,'LineWidth',1.5)
% %     plot(dW_dp_delta_num,y_top,'LineStyle','--','Color','m','LineWidth',1.5)
%     plot(W_ddelta_dp,y_top,'LineStyle','-','Color','k','LineWidth',1.5)     
% %     plot(W_ddelta_dp_2,y_top,'LineStyle','-','Color',green,'LineWidth',1.5)     
%     x_plot_max_local = max([max(dR_dp),max(dW_dp_delta),max(W_ddelta_dp)]);
%     x_plot_min_local = min([min(dR_dp),min(dW_dp_delta),min(W_ddelta_dp)]);
%     Delta_x_plot = x_plot_max_local - x_plot_min_local;
%     margin = 0.05 * Delta_x_plot;
%     line([x_plot_min_local-margin x_plot_max_local+margin],[y_tilde(3),y_tilde(3)],...
%         'LineStyle','-','Color',blue,'LineWidth',0.5)
%     line([x_plot_min_local-margin x_plot_max_local+margin],[y_tilde(4),y_tilde(4)],...
%         'LineStyle','-','Color',blue,'LineWidth',0.5)
%     line([0 0],[y_plot_min_delta_2,y_plot_max_delta_2],'LineStyle','-','Color','k','LineWidth',0.5)
%     hold off
%     axis([x_plot_min_local-margin x_plot_max_local+margin y_plot_min_delta_2 y_plot_max_delta_2])
% %     axis([-1.5 30.0 y_plot_min_delta_2 y_plot_max_delta_2])
%     box on
%     grid on
%     xlabel('$\rm {\it \dot R}, {\it \dot W \delta}, {\it W \dot\delta}$ (-)','Interpreter',...
%         'latex','FontSize',11)
%     ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
%     legend('$\it \dot R$',...
%         '$\it \dot W \delta$',...
%         '$\it W \dot\delta$',...
%         'Interpreter','latex',...
%         'FontSize',11,'location','southeast')
end

% Plot slip patch nucleation length as computed from simulation and eigen values:
% if flag_fric == 2 && flag_plot_eig == 1 && flag_paper == 0 && flag_loc_seismic > 0
if flag_plot_diag == 1 && flag_fric == 2 && flag_plot_eig == 1 && flag_paper == 0 && flag_loc_seismic > 0
%    figure 
    subplot(1,3,2)
    hold on
    plot(-p_plot(2:end-1)/1e6,Delta_y_plot_top(2:end-1),'-','Color','r','LineWidth',1.5);
    plot(-p_plot(2:end-1)/1e6,1./e_plot(3:end),'-','Color',blue,'LineWidth',1.5); % note shift!
%     plot(-p(2:length(p_plot)-1)/1e6,epsilon(2:length(p_plot)-1),'LineStyle','-','Color',green,'LineWidth',1.5)
%     plot(-p(2:length(p_plot)-1)/1e6,(1+epsilon(2:length(p_plot)-1)).*(1./e_plot(3:end)),'LineStyle','-','Color',orange,'LineWidth',1.5)
%     plot(-p_plot(2:end-1)/1e6,Delta_y_UR_plot(2:end-1),'-','Color',green,'LineWidth',1.5);
    plot(-p_plot(end-1)/1e6,Delta_y_plot_top(end-1),'p','MarkerSize',12,'MarkerEdgeColor',...
    'r','MarkerFaceColor','r');
%     plot(-p_plot(end-1)/1e6,1./e_plot(end),'^','MarkerSize',9,'MarkerEdgeColor',...
%     blue,'MarkerFaceColor','none'); % note shift!
    line([-p_seismic/1e6 -p_seismic/1e6],[0 30],...
        'LineStyle',':','Color','r','LineWidth',1.0)
    hold off
    xlabel('$\it -p$ (MPa)','Interpreter','latex','FontSize',11)
    ylabel('$\Delta{\it y}$ (m)','Interpreter','latex','FontSize',11)
    % axis([-p_max/1e6 -p_min/1e6 0 inf])
%      axis([13 18 -inf inf])
    axis([14 18 0 22])
%     legend('$\Delta {\it y^*_{sim}}$','$\Delta {\it y^*_{eig}}$','$\Delta {\it y^*_{U\&R}}$',...
%         'Interpreter','latex','FontSize',12,'location','SouthWest')
    legend('$\Delta{\it y_{sim}}$','$\Delta {\it y_{eig}}$',...
        'Interpreter','latex','FontSize',11,'location','SouthEast')
    box on
    grid on
    
    subplot(1,3,3)
    hold on
    dp_dDelta_y_num_bot_plot = dp_dDelta_y_num_bot(1:length(p_plot));
    dp_dDelta_y_num_top_plot = dp_dDelta_y_num_top(1:length(p_plot));
    plot(-p_plot(2:end)/1e6,dp_dDelta_y_num_bot_plot(2:end)/1e6,'-','Color',blue,'LineWidth',1.5);
    plot(-p_plot(2:end)/1e6,dp_dDelta_y_num_top_plot(2:end)/1e6,'-','Color','r','LineWidth',1.5);
    line([-p_eig/1e6 -p_eig/1e6],[0 1],'LineStyle',':','Color',blue,'LineWidth',1.0)
    line([-p_seismic/1e6 -p_seismic/1e6],[0 1],'LineStyle',':','Color','r','LineWidth',1.0)
    hold off
    xlabel('$\it -p$ (MPa)','Interpreter','latex','FontSize',11)
    ylabel('$\dot\Delta{\it y^{\rm-1}}$ (MPa/m)','Interpreter','latex','FontSize',11)
    % axis([-p_max/1e6 -p_min/1e6 0 inf])
%      axis([13 18 -inf inf])
    axis([14 18 0 1])
    legend('$\dot\Delta{\it y^{\rm-1}_{bot}}$', ...
           '$\dot\Delta{\it y^{\rm-1}_{top}}$',...
        'Interpreter','latex','FontSize',11,'location','NorthEast')
    box on
    grid on
end

% Plot field plots:
if flag_plot_fields == 1 && flag_cheb == 1 && flag_check == 0 
    figure 
    subplot(2,2,1) % slip
    p_plot_min = -p_plot(1)/1e6; % MPa
    p_plot_max = -p_plot(end)/1e6; % MPa
    y_plot_min = y_plot_min_delta_2; % m
    y_plot_max = y_plot_max_delta_2; % m
    x = [p_plot_min p_plot_max]; % MPa
    y = [y_plot_min y_plot_max]; % m
    p_fields = linspace(p_plot_min,p_plot_max,n_plot_fields_p); % MPa
    delta_fields_int = interp1(-p_plot/1e6,delta_fields(:,1:length(p_plot))',p_fields)'; % m
    imagesc(x/1e6,-y,delta_fields_int*1e3) % mm
    colorbar
    axis off
    ax1 = gca;
    axes('Position',get(ax1,'Position'),...
        'XAxisLocation','bottom',...
        'YAxisLocation','left',...
        'Color','none');
    axis([p_plot_min p_plot_max y_plot_min y_plot_max])
    box on
    xlabel('$\it -p$ (MPa)','Interpreter','latex','FontSize',11)
    ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
    title('$\it \delta$ (mm)','Interpreter','latex','FontSize',11)
    
    subplot(2,2,2) % slip rate
    t_plot_min = T_y * p_plot(1) / p_min_bounds; % y
    t_plot_max = T_y * p_plot(end) / p_min_bounds; % y
    x = [t_plot_min t_plot_max]; % y
    delta_fields_int = interp1(-p_plot/1e6,delta_fields(:,1:length(p_plot))',p_fields)'; % m 
    Delta_t = (t_plot_max-t_plot_min)/(n_plot_fields_t-1); % y
    ddelta_dt_fields_int = diff(delta_fields_int')' / Delta_t; % m/y
    imagesc(x,-y,ddelta_dt_fields_int*1000/365) % mm/d 
    colorbar
    axis off
    ax1 = gca;
    axes('Position',get(ax1,'Position'),...
        'XAxisLocation','bottom',...
        'YAxisLocation','left',...
        'Color','none');
    axis([t_plot_min t_plot_max y_plot_min y_plot_max])
    box on
    xlabel('$\it t$ (y)','Interpreter','latex','FontSize',11)
    ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
    title('$\it \dot\delta$ (mm/d)','Interpreter','latex','FontSize',11)
    
    subplot(2,2,3) % slip gradient
    x = [p_plot_min p_plot_max]; % MPa
    ddelta_ds_fields_int = interp1(-p_plot/1e6,ddelta_ds_fields(:,1:length(p_plot))',p_fields)'; % m/m
    imagesc(x/1e6,-y,ddelta_ds_fields_int*1e3) % mm/m
    colorbar
    axis off
    ax1 = gca;
    axes('Position',get(ax1,'Position'),...
        'XAxisLocation','bottom',...
        'YAxisLocation','left',...
        'Color','none');
    axis([p_plot_min p_plot_max y_plot_min y_plot_max])
    box on
    xlabel('$\it -p$ (MPa)','Interpreter','latex','FontSize',11)
    ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
    title('$\it \nabla \delta$ (mm/m)','Interpreter','latex','FontSize',11)

    subplot(2,2,4) % slip gradient rate
    x = [t_plot_min t_plot_max]; % y
    d2delta_ds_dt_fields_int = diff(ddelta_ds_fields_int')' / Delta_t; % m/(m*y)
    imagesc(x/1e6,-y,d2delta_ds_dt_fields_int*1e3/365) % mm/(m*d)
    colorbar
    axis off
    ax1 = gca;
    axes('Position',get(ax1,'Position'),...
        'XAxisLocation','bottom',...
        'YAxisLocation','left',...
        'Color','none');
    axis([t_plot_min t_plot_max y_plot_min y_plot_max])
    box on
    xlabel('$\it t$ (y)','Interpreter','latex','FontSize',11)
    ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
    title('$\it \nabla \dot\delta$ (mm/(m*d))','Interpreter','latex','FontSize',11)
end

% Plot diagnostics to check pressure stepping algorithm:
if flag_plot_diag == 1
    fault_slip_plot_diag_history(colors,Delta_p_max,Delta_p_min,Delta_p_plot,...
        Delta_y_max_obs_plot,Delta_y_target,flag_plot_cap,p_max_bounds,p_min_bounds,...
        p_plot,p_seismic);    
end

% Write to screen:
if flag_fric > 1 && flag_paper == 0 && flag_echo > 0
    if flag_seismic == 1
        if flag_loc_seismic == 1 
            fprintf('Delta y*_sim = %5.2f m\r', Delta_y_plot_bot(end-1));
        else
            fprintf('Delta y*_sim = %5.2f m\r', Delta_y_plot_top(end-1));
        end
        fprintf('Delta y*_eig = %5.2f m\r', 1/e_plot(end));
        fprintf('Delta y*_U&R = %5.2f m\r', Delta_y_UR_plot(end));
        fprintf('      p*_sim = %5.2f MPa\r', p_seismic/1e6);
        fprintf('      p*_eig = %5.2f MPa\r\r', p_eig/1e6);
        if flag_loc_seismic == 1 
            fprintf( 'Relative error between Delta y*_sim and Delta y*_eig = %5.2f. \r', ...
                (Delta_y_plot_bot(end-1) - 1/e_plot(end))/(1/e_plot(end)) );
        else
            fprintf( 'Relative difference between Delta y*_sim and Delta y*_eig = %5.2f. \r', ...
                (Delta_y_plot_top(end-1) - 1/e_plot(end))/(1/e_plot(end)) );          
        end       
            help = nonzeros(Delta_p);
            Delta_p_last = help(end); 
            fprintf( 'Last pressure step size = %5.2f. \r\r', Delta_p_last);          
    else
        fprintf('\rMaximum depletion reached without seismicity.\r\r');
    end
end
